/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.git.core.model.GitRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitRevSpecifier {
    private List<String> parameters;

    public GitRevSpecifier(String ... parameters) {
        this.parameters = Arrays.asList(parameters);
    }

    GitRevSpecifier(GitRef newRef) {
        this.parameters = new ArrayList<String>();
        this.parameters.add(newRef.ref());
    }

    List<String> parameters() {
        return this.parameters;
    }

    static GitRevSpecifier allBranchesRevSpec() {
        return new GitRevSpecifier("--all");
    }

    static GitRevSpecifier localBranchesRevSpec() {
        return new GitRevSpecifier("--branches");
    }

    boolean isSimpleRef() {
        return this.parameters.size() == 1 && (this.parameters.get(0).length() == 0 || this.parameters.get(0).charAt(0) != '-');
    }

    public GitRef simpleRef() {
        if (!this.isSimpleRef()) {
            return null;
        }
        return GitRef.refFromString(this.parameters.get(0));
    }

    boolean hasLeftRight() {
        for (String param : this.parameters) {
            if (!param.equals("--left-right")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String param : this.parameters) {
            builder.append(param).append(' ');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GitRevSpecifier)) {
            return false;
        }
        GitRevSpecifier other = (GitRevSpecifier)obj;
        if (other.parameters.size() != this.parameters.size()) {
            return false;
        }
        int i = 0;
        while (i < this.parameters.size()) {
            String param = this.parameters.get(i);
            if (!other.parameters.get(i).equals(param)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

